/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.process.diagram;

import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.VWDesignerPreferences;
import filenet.vw.toolkit.design.canvas.VWDesignerTabbedCanvasPanel;
import filenet.vw.toolkit.design.canvas.process.IVWProcessCanvasPanel;
import filenet.vw.toolkit.design.canvas.process.VWProcessActionMenu;
import filenet.vw.toolkit.design.canvas.process.diagram.VWDiagramPropertyPanel;
import filenet.vw.toolkit.design.canvas.process.diagram.VWDiagramStepPalettePanel;
import filenet.vw.toolkit.design.mapui.VWDesignerWorkflowPane;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.utils.VWSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.Beans;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JPanel;

public class VWDiagramCanvasPanel
extends JPanel
implements IVWProcessCanvasPanel,
IVWMapChangedListener {
    private static final String CLASS_NAME_WORKFLOW_PANE = VWDesignerWorkflowPane.class.getName();
    private static final String CLASS_NAME_WORKFLOW_PROPERTY_PANE = VWDiagramPropertyPanel.class.getName();
    private static final String CLASS_NAME_STEP_PALETTE_PANEL = VWDiagramStepPalettePanel.class.getName();
    private VWSplitPane m_viewSplitPane = null;
    private VWDesignerTabbedCanvasPanel m_designerTabbedCanvasPanel = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWDesignerWorkflowPane m_designerWorkflowPane = null;
    private VWDiagramPropertyPanel m_diagramPropertyPanel = null;
    private VWDiagramStepPalettePanel m_diagramStepPalettePanel = null;
    private VWProcessActionMenu m_processActionMenu = null;

    public VWDiagramCanvasPanel(VWDesignerTabbedCanvasPanel designerTabbedCanvasPanel, VWAuthPropertyData authPropertyData) {
        this.m_designerTabbedCanvasPanel = designerTabbedCanvasPanel;
        this.m_authPropertyData = authPropertyData;
        this.createControls();
        this.updateBeans();
    }

    public void selectItemInProcess(Object[] eventItems) {
        if (this.m_diagramPropertyPanel != null) {
            this.m_diagramPropertyPanel.handleItemStateEvent(1, eventItems);
        }
    }

    public void initializeActionMenu(JMenu actionMenu) {
        if (this.m_processActionMenu == null) {
            this.m_processActionMenu = new VWProcessActionMenu(this);
        }
        this.m_processActionMenu.initializeMenu(actionMenu);
    }

    public void initializeEditMenu(JMenu editMenu) {
    }

    public VWAuthPropertyData getAuthPropertyData() {
        return this.m_authPropertyData;
    }

    public VWDesignerTabbedCanvasPanel getTabbedCanvasPanel() {
        return this.m_designerTabbedCanvasPanel;
    }

    public VWDesignerWorkflowPane getWorkflowPane() {
        return this.m_designerWorkflowPane;
    }

    public void displayWorkflowProperties() {
        if (this.m_diagramPropertyPanel != null) {
            this.m_diagramPropertyPanel.showWorkflowProperties();
        }
    }

    public void showInheritedWorkflowInformation(boolean bNewDisplayInheritedItemsValue) {
    }

    public void stopEditing() {
        if (this.m_diagramPropertyPanel != null) {
            this.m_diagramPropertyPanel.fireTableActionNotification(100);
        }
    }

    public void displayWaitCursor() {
        this.m_authPropertyData.displayWaitCursor(this);
    }

    public void restoreDefaultCursor() {
        this.m_authPropertyData.restoreDefaultCursor(this);
    }

    public void setSelected() {
    }

    public void releaseReferences() {
        if (this.m_viewSplitPane != null) {
            this.m_viewSplitPane.removeAll();
            this.m_viewSplitPane = null;
        }
        if (this.m_designerWorkflowPane != null) {
            this.m_designerWorkflowPane.releaseReferences();
            this.m_designerWorkflowPane = null;
        }
        if (this.m_diagramPropertyPanel != null) {
            this.m_diagramPropertyPanel.releaseReferences();
            this.m_diagramPropertyPanel = null;
        }
        if (this.m_diagramStepPalettePanel != null) {
            this.m_diagramStepPalettePanel.releaseReferences();
            this.m_diagramStepPalettePanel = null;
        }
        if (this.m_processActionMenu != null) {
            this.m_processActionMenu.releaseReferences();
            this.m_processActionMenu = null;
        }
        this.m_designerTabbedCanvasPanel = null;
        this.m_authPropertyData = null;
    }

    public void mapChanged(VWMapChangedEvent event) {
        try {
            switch (event.getID()) {
                case 103: {
                    this.updateBeans();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createControls() {
        this.setLayout(new BorderLayout());
        try {
            this.m_diagramStepPalettePanel = (VWDiagramStepPalettePanel)Beans.instantiate(this.getClass().getClassLoader(), CLASS_NAME_STEP_PALETTE_PANEL);
            this.m_designerWorkflowPane = (VWDesignerWorkflowPane)Beans.instantiate(this.getClass().getClassLoader(), CLASS_NAME_WORKFLOW_PANE);
            this.m_designerWorkflowPane.init(this, this.m_diagramStepPalettePanel);
            this.m_designerWorkflowPane.setViewOnly(false);
            this.m_authPropertyData.setMapCache(this.m_designerWorkflowPane.getMapCache());
            this.m_authPropertyData.setShowInheritedProperties(this.getDesignerPreferences().getShouldDisplayInheritedInformation());
            this.m_diagramPropertyPanel = (VWDiagramPropertyPanel)Beans.instantiate(this.getClass().getClassLoader(), CLASS_NAME_WORKFLOW_PROPERTY_PANE);
            this.m_diagramPropertyPanel.init(this.m_authPropertyData);
            this.m_designerWorkflowPane.addItemListener(this.m_diagramPropertyPanel);
            this.m_designerWorkflowPane.addIVWMapItemsListener(this.m_diagramPropertyPanel);
            this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this.m_designerWorkflowPane);
            this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
            this.m_authPropertyData.getSelectionChangeEventNotifier().addItemListener(this.m_designerWorkflowPane);
        }
        catch (ClassNotFoundException ex) {
            VWDebug.logError("Cannot find class " + ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            VWDebug.logError("Cannot load class " + ex.getLocalizedMessage());
        }
        Thread.yield();
        this.m_viewSplitPane = new VWSplitPane(0, this.m_designerWorkflowPane, this.m_diagramPropertyPanel);
        this.m_viewSplitPane.setOneTouchExpandable(true);
        this.m_viewSplitPane.setDividerLocation(0.65);
        this.m_viewSplitPane.setResizeWeight(1.0);
        this.add((Component)this.m_viewSplitPane, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateBeans() {
        block11: {
            try {
                try {
                    if (this.m_authPropertyData != null) {
                        this.m_authPropertyData.displayWaitCursor(this);
                        Thread.yield();
                        if (this.m_designerWorkflowPane != null && this.m_diagramPropertyPanel != null) {
                            this.m_designerWorkflowPane.removeItemListener(this.m_diagramPropertyPanel);
                            this.m_designerWorkflowPane.removeIVWMapItemsListener(this.m_diagramPropertyPanel);
                            this.m_authPropertyData.getMapChangeEventNotifier().removeMapChangedListener(this.m_designerWorkflowPane);
                            this.m_authPropertyData.getSelectionChangeEventNotifier().removeItemListener(this.m_designerWorkflowPane);
                        }
                        Thread.yield();
                        VWWorkflowDefinition workflowDef = this.m_authPropertyData.getWorkflowDefinition();
                        VWWorkflowDefinition baseWorkflowDef = this.m_authPropertyData.getBaseWorkflowDefinition();
                        if (workflowDef != null && baseWorkflowDef == null && this.getDesignerPreferences().getShouldDisplayInheritedInformation()) {
                            baseWorkflowDef = this.m_authPropertyData.getDesignerCoreData().fetchBaseWorkflowDefinition(workflowDef);
                        }
                        this.m_authPropertyData.setWorkflowDefinitions(workflowDef, baseWorkflowDef);
                        if (this.m_designerWorkflowPane != null) {
                            this.m_designerWorkflowPane.setWorkflowDefinition(workflowDef, baseWorkflowDef);
                        }
                        this.m_authPropertyData.getMapChangeEventNotifier().notifyMapChange(554);
                        this.m_authPropertyData.setCurrentMapEditable(this.m_authPropertyData.getMapCache().isEditable("Workflow"));
                        Thread.yield();
                    }
                }
                catch (Exception ex1) {
                    VWDebug.logException(ex1);
                    Object var4_5 = null;
                    if (this.m_designerWorkflowPane != null && this.m_diagramPropertyPanel != null) {
                        this.m_designerWorkflowPane.addItemListener(this.m_diagramPropertyPanel);
                        this.m_designerWorkflowPane.addIVWMapItemsListener(this.m_diagramPropertyPanel);
                        this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this.m_designerWorkflowPane);
                        this.m_authPropertyData.getSelectionChangeEventNotifier().addItemListener(this.m_designerWorkflowPane);
                        this.m_designerWorkflowPane.setFocusStep(0);
                    }
                    if (this.m_authPropertyData == null) return;
                    this.m_authPropertyData.restoreDefaultCursor(this);
                    return;
                }
                Object var4_4 = null;
                if (this.m_designerWorkflowPane == null || this.m_diagramPropertyPanel == null) break block11;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (this.m_designerWorkflowPane != null && this.m_diagramPropertyPanel != null) {
                    this.m_designerWorkflowPane.addItemListener(this.m_diagramPropertyPanel);
                    this.m_designerWorkflowPane.addIVWMapItemsListener(this.m_diagramPropertyPanel);
                    this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this.m_designerWorkflowPane);
                    this.m_authPropertyData.getSelectionChangeEventNotifier().addItemListener(this.m_designerWorkflowPane);
                    this.m_designerWorkflowPane.setFocusStep(0);
                }
                if (this.m_authPropertyData == null) throw throwable;
                this.m_authPropertyData.restoreDefaultCursor(this);
                throw throwable;
            }
            this.m_designerWorkflowPane.addItemListener(this.m_diagramPropertyPanel);
            this.m_designerWorkflowPane.addIVWMapItemsListener(this.m_diagramPropertyPanel);
            this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this.m_designerWorkflowPane);
            this.m_authPropertyData.getSelectionChangeEventNotifier().addItemListener(this.m_designerWorkflowPane);
            this.m_designerWorkflowPane.setFocusStep(0);
        }
        if (this.m_authPropertyData == null) return;
        this.m_authPropertyData.restoreDefaultCursor(this);
    }

    private VWDesignerPreferences getDesignerPreferences() {
        return this.m_authPropertyData.getDesignerCoreData().getDesignerPreferences();
    }
}

